% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getBraggDopplerAngularFrequency}
\alias{seasonder_getBraggDopplerAngularFrequency}
\title{Calculate the Bragg Doppler Angular Frequency}
\usage{
seasonder_getBraggDopplerAngularFrequency(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the necessary data
to compute the radar wave number.}
}
\value{
A numeric vector of length two, containing the negative and positive
Bragg Doppler angular frequencies (in radians per second).
}
\description{
This function computes the Bragg Doppler angular frequencies for a SeaSonde radar
system. These frequencies represent the characteristic Doppler shifts due to
wave resonance at the Bragg wavelength.
}
\details{
The Bragg Doppler angular frequency \eqn{\omega_B} is calculated using the formula
\eqn{\omega_B = \sqrt{2 \cdot g \cdot k}}
where:
\itemize{
\item \eqn{g} is the gravitational acceleration (approximately \eqn{9.8 \, m/s^2}),
\item \eqn{k} is the radar wave number in radians per meter.
}

The returned vector contains the negative (\eqn{-\omega_B}) and positive (\eqn{+\omega_B}) angular frequencies.
}
\seealso{
\code{\link{seasonder_getRadarWaveNumber}} to compute the radar wave number.
}
