% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getSeaSondeRCS_MUSIC_BinsRadialVelocity}
\alias{seasonder_getSeaSondeRCS_MUSIC_BinsRadialVelocity}
\title{Retrieve Radial Velocities for MUSIC Doppler Bins}
\usage{
seasonder_getSeaSondeRCS_MUSIC_BinsRadialVelocity(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object representing the cross-spectral data structure.
It contains necessary metadata and Doppler frequency information.}
}
\value{
A numeric vector containing the radial velocities corresponding to each MUSIC Doppler bin.
}
\description{
This function calculates the radial velocities for MUSIC Doppler bins based on the given
SeaSonde cross-spectral object.
}
\details{
The function uses the following process:
\itemize{
\item It retrieves the Doppler bin frequencies using \code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency}}.
\item It computes the radial velocities associated with the bins using \code{\link{seasonder_computeBinsRadialVelocity}}.
}

The computed velocities are returned as a numeric vector, which can be used in subsequent
analyses or visualizations.
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency}},
\code{\link{seasonder_computeBinsRadialVelocity}}
}
