% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_readSeaSondeRAPMFile}
\alias{seasonder_readSeaSondeRAPMFile}
\title{Read and Parse a SeaSonde APM File}
\usage{
seasonder_readSeaSondeRAPMFile(
  file_path,
  override_antenna_bearing = NULL,
  override_phase_corrections = NULL,
  override_amplitude_factors = NULL,
  override_SiteOrigin = NULL,
  ...
)
}
\arguments{
\item{file_path}{The path to the SeaSonde APM file to read.}

\item{override_antenna_bearing}{If not NULL, overrides the Antenna Bearing data in the file.}

\item{override_phase_corrections}{If not NULL, overrides the phase corrections in the file.}

\item{override_amplitude_factors}{If not NULL, overrides the amplitude factors in the file.}

\item{override_SiteOrigin}{If not NULL, overrides the SiteOrigin attribute.}

\item{...}{Additional arguments passed to the object creation function.}
}
\value{
A SeaSondeRAPM object containing the parsed data.
}
\description{
This function reads a SeaSonde APM file and returns a SeaSondeRAPM object containing
the parsed data.
}
\examples{
# Read a test SeaSondeRAPM object from sample file
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
}
\seealso{
\code{\link{seasonder_createSeaSondeRAPM}}

\code{\link{seasonder_validateAttributesSeaSondeRAPM}}
}
