% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_skip_cs_field}
\alias{seasonder_skip_cs_field}
\title{Skip Reading a CSField and Return a Specified Value}
\usage{
seasonder_skip_cs_field(cond, value)
}
\arguments{
\item{cond}{A condition or error that occurred while reading the CSField.}

\item{value}{The desired return value to use in place of the CSField reading that encountered an error.}
}
\value{
The value specified in the 'value' parameter.
}
\description{
This function is a convenience mechanism to invoke the \code{seasonder_skip_cs_field} restart option. It can be used in custom condition handlers when reading a CSField from a binary connection encounters an error or condition. When called, it indicates the intention to skip reading the current CSField and return a specific value.
}
\details{
During the execution of the \code{seasonder_readCSField} function, errors or conditions can occur. To provide a structured mechanism to handle such cases, the function utilizes the \code{rlang::withRestarts} mechanism, offering a restart option named \code{seasonder_skip_cs_field}. This restart allows the function to gracefully handle reading errors by logging a relevant error message and returning a specified value.

The \code{seasonder_skip_cs_field} function provides an easy way to invoke this restart. When called within a custom condition handler, it signals the intention to skip the current CSField reading due to an error and specifies a return value.
}
\examples{
# Example: Skip reading a CSField using a withRestarts handler to return a default value
r <- withRestarts(
  seasonder_skip_cs_field(simpleError("test error"), "default"),
  seasonder_skip_cs_field = function(cond, value) value
)
print(r)
}
