% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_grids.R
\name{complete_regular_grid}
\alias{complete_regular_grid}
\title{Expand Regular Spatial Grid}
\usage{
complete_regular_grid(dt)
}
\arguments{
\item{dt}{A data table object containing the spatial grid with coordinates.}
}
\value{
A data table with the completed spatial grid. Has the grid-attribute.
}
\description{
First checks whether the spatial coordinates in a data table are part of a \emph{regular grid}.
If they are, the function returns the smallest \emph{regular complete grid} including all coordinates.
See \code{\link{set_spatial_grid}} for more information.
}
\examples{
  dt = data.table(lon = c(1, 2, 3), lat = c(1, 2, 3))
  completed_grid = complete_regular_grid(dt)
  print(completed_grid)


}
