% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{tfc_gha_plot}
\alias{tfc_gha_plot}
\title{Plotting function with different map for Greater Horn of Africa}
\usage{
tfc_gha_plot(
  ...,
  expand.x = c(-0.5, 0.5),
  expand.y = c(-0.5, 2),
  showplot = TRUE
)
}
\arguments{
\item{..., expand.x, expand.y, showplot}{passed to \code{\link[=tfc_plot]{tfc_plot()}}.}
}
\description{
This function wraps \code{\link[=tfc_plot]{tfc_plot()}}, but uses a different map for borders.
The map is part of the package and is the one currently used during GHACOFs at ICPAC.
}
\examples{
dt = tfc_from_efc(ecmwf_monthly[month == 11 & lat < 0])
pp = tfc_gha_plot(dt[year == 2018], expand.y = c(0.5,0.5))
if(interactive()) plot(pp)

}
