test_that("parameters parsing", {
  # use try and then to check the error
  Phi_fn <- function(theta, lambda, alpha) 2 * theta + alpha * lambda
  Psi_fn <- function(theta, lambda, alpha) 2 * lambda + alpha * theta
  # build quasi jacobiean by package NumDeriv
  res <- try(semislv(1, 1, Phi_fn, Psi_fn, alpha = 1))
  expect_equal(class(res), "savespace")
  # the necessary parameter missing
  res <- try(semislv(1, 1, Psi_fn, method = "implicit", alpha = 1))
  expect_equal(class(res), "try-error")
  # the wrong input for the method
  res <- try(semislv(1, 1, Phi_fn, Psi_fn, method = "ip", alpha = 1))
  expect_equal(class(res), "try-error")
  # the wrong input for the control
  res <- try(semislv(theta = 1, lambda = 1, Phi_fn = Phi_fn, Psi_fn = Psi_fn, method = "iterative", save = list(space = TRUE), alpha = 1))
  expect_equal(class(res), "savespace")
  # the wrong input for the save
  expect_error(semislv(1, 1, Phi_fn, Psi_fn, save = list(path = "nice"), alpha = 1))

  # parsing all mathematical Jacobian function by user
  res <- try(semislv(1, 1, Phi_fn, Psi_fn, jac = list(
    Phi_der_theta_fn = function(theta, lambda, alpha) 2,
    Phi_der_lambda_fn = function(theta, lambda, alpha) alpha,
    Psi_der_theta_fn = function(theta, lambda, alpha) alpha,
    Psi_der_lambda_fn = function(theta, lambda, alpha) 2
  ), method = "implicit", alpha = 1))
  expect_equal(class(res), "savespace")
  res <- try(semislv(1, 1, Phi_fn, Psi_fn, jac = list(
    Phi_der_theta_fn = function(theta, lambda, alpha) 2,
    Psi_der_lambda_fn = function(theta, lambda, alpha) 2
  ), method = "iterative", alpha = 1))
  expect_equal(class(res), "savespace")
  # parsing partial mathemetical user-provided Jacobian, the rest will be generated by the NumDeriv
  res <- try(semislv(1, 1, Phi_fn, Psi_fn,
    jac = list(Phi_der_theta_fn = function(theta, lambda, alpha) 2),
    method = "implicit", alpha = 1
  ))
  expect_equal(class(res), "savespace")
  res <- try(semislv(1, 1, Phi_fn, Psi_fn,
    jac = list(Phi_der_theta_fn = function(theta, lambda, alpha) 2),
    method = "iterative", alpha = 1
  ))
  expect_equal(class(res), "savespace")
})