% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fulldata_model.R, R/predict_within_group.R
\name{predict.SensIAT_fulldata_model}
\alias{predict.SensIAT_fulldata_model}
\alias{predict.SensIAT_within_group_model}
\title{Give the Marginal Mean Estimate and its Estimated Asymptotic Variance}
\usage{
\method{predict}{SensIAT_fulldata_model}(object, time, ...)

\method{predict}{SensIAT_within_group_model}(object, time, include.var = TRUE, ..., base = object$base)
}
\arguments{
\item{object}{SensIAT_within_group_model object}

\item{time}{Time points of interest}

\item{...}{Currently ignored.}

\item{include.var}{Logical. If TRUE, the variance of the outcome is also returned}

\item{base}{A \code{SplineBasis} object used to evaluate the basis functions.}
}
\value{
If include.var is TRUE, a \code{tibble} with columns time, mean, and var is returned.
otherwise if include.var is FALSE, only the mean vector is returned.
}
\description{
Give the marginal mean model estimate
}
\section{Functions}{
\itemize{
\item \code{predict(SensIAT_fulldata_model)}: For each combination of \code{time} and \code{alpha} estimate the mean response and
variance for each group as well as estimate the mean treatment effect and
variance.

}}
\examples{
\donttest{
model <-
    fit_SensIAT_within_group_model(
        group.data = SensIAT_example_data,
        outcome_modeler = fit_SensIAT_single_index_fixed_coef_model,
        alpha = c(-0.6, -0.3, 0, 0.3, 0.6),
        id = Subject_ID,
        outcome = Outcome,
        time = Time,
        End = 830,
        knots = c(60,260,460),
    )
predict(model, time = c(90, 180))
}
}
