# R package repository

This repository contains the codes and a tutorial for the R package "SiFINeT" v1.13.

The corresponding paper is "SifiNet: A robust and accurate method to identify feature gene sets and annotate cells".

SifiNet is a robust and accurate computational pipeline for identifying distinct gene sets, extracting and annotating cellular subpopulations, and elucidating intrinsic relationships among these subpopulations. Uniquely, SifiNet bypasses the cell clustering stage, commonly integrated into other cellular annotation pipelines, thereby circumventing potential inaccuracies in clustering that may compromise subsequent analyses. Consequently, SifiNet has demonstrated superior performance in multiple experimental datasets compared with other state-of-the-art methods. SifiNet can analyze both single-cell RNA and ATAC sequencing data, thereby rendering comprehensive multiomic cellular profiles.

Please check the tutorial "SifiNet_tutorial.Rmd" for installation and a toy analysis example.

The codes to generate the analysis results in the paper can be found [here](https://github.com/jichunxie/SifiNet_manu_support).
