% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.functions.R
\name{make.categorical.draw}
\alias{make.categorical.draw}
\title{Function that makes a draw from a categorical distribution}
\usage{
make.categorical.draw(inheritances, weights)
}
\arguments{
\item{inheritances}{A vector of inheritance probabilities}

\item{weights}{A vector of weights for each inheritance probability}
}
\value{
A function that makes draws from a categorical distribution.
}
\description{
Create a function that makes draws from a categorical distribution. Function calls \code{sample(x=inheritances,size=1,prob=weights)}
}
\examples{
set.seed(17)
inher_func<-make.categorical.draw(inheritances=c(0.25,0.50,0.75),weights=c(0.25,0.5,0.25))
net<-sim.bdh.age(1,1,5,2,1,c(1/3,1/3,1/3),hyb.inher.fxn = inher_func,
complete=TRUE)[[1]]
}
