% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix.pacf.R
\name{fix.pacf}
\alias{fix.pacf}
\title{Generate Partial Autocorrelation Function (PACF) by User Specifying}
\usage{
fix.pacf(ts, c, lag, type, or = 4, m = 500)
}
\arguments{
\item{ts}{ts is the data set which is a time series data typically}

\item{c}{c indicates the number of basis used to Estimate (For wavelet, the number of basis is 2^c. If
Cspli is chosen, the real number of basis is c-2+or)}

\item{lag}{lag b is the lag for auto-regressive model}

\item{type}{type indicates which type of basis is used (There are 31 types in this package)}

\item{or}{or indicates the order of spline and only used in Cspli type, default is 4 which indicates cubic spline}

\item{m}{m indicates the number of points of coefficients to Estimate}
}
\value{
A vector which contains the PACF with specific lag
}
\description{
fix.pacf() generates the PACF with fixed tuning parameters.
}
\examples{
set.seed(137)
time.series = c()
n = 1024
v = 25
w = rnorm(n, 0, 1) / v
x_ini = runif(1,0,1)
for(i in 1:n){
  if(i == 1){
    time.series[i] = 0.2 + 0.6*cos(2*pi*(i/n))*x_ini  + w[i] #
  } else{
    time.series[i] = 0.2 + 0.6*cos(2*pi*(i/n))*time.series[i-1] + w[i]
  }
}
fix.pacf(time.series, c=5, lag = 1, type = "Legen")
}
