% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mito.R
\name{ReadMGATK}
\alias{ReadMGATK}
\title{Read MGATK output}
\usage{
ReadMGATK(dir, verbose = TRUE)
}
\arguments{
\item{dir}{Path to directory containing MGATK output files}

\item{verbose}{Display messages}
}
\value{
Returns a list containing a sparse matrix (counts) and two dataframes
(depth and refallele).

The sparse matrix contains read counts for each base at each position
and strand.

The depth dataframe contains the total depth for each cell.
The refallele dataframe contains the reference genome allele at each
position.
}
\description{
Read output files from MGATK (\url{https://github.com/caleblareau/mgatk}).
}
\examples{
\dontrun{
data.dir <- system.file("extdata", "test_mgatk", package="Signac")
mgatk <- ReadMGATK(dir = data.dir)
}
}
\concept{mito}
