% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_FilterSlick.R
\name{FilterSlick}
\alias{FilterSlick}
\title{FilterSlick}
\usage{
FilterSlick(slick = NULL, MPs = NULL, OMs = NULL, PIs = NULL, plot = NULL)
}
\arguments{
\item{slick}{An object of class \code{Slick}}

\item{MPs}{Numeric values of the MPs to keep. Default NULL keeps all MPs.}

\item{OMs}{Numeric values of the OMs to keep (rows of \code{OM@Design}). Default NULL keeps all OMs.}

\item{PIs}{Numeric values of the PIs in \code{plot} to keep. Default NULL keeps all PIs.}

\item{plot}{The plot to filter the PIs. One of: \code{Timeseries}, \code{Boxplot}, \code{Kobe},
\code{Quilt}, \code{Spider},  or\code{Tradeoff}}
}
\value{
A filtered Slick Object
}
\description{
Filter a Slick Object
}
\details{
Filter a Slick Object by management procedures (MPs),
operating models (OMs), and performance indicators (PIs) for a given plot
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
slick <- Slick() # a completed slick object
boxplot_OM_1 <- FilterSlick(slick, OMs=1, plot='boxplot')


\dontshow{\}) # examplesIf}
}
