% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_SlidingWindows.R
\name{dmc.SlidingWindows}
\alias{dmc.SlidingWindows}
\title{Detrended multiple cross-correlation coefficient with sliding windows.}
\usage{
dmc.SlidingWindows(x1, x2, y, w = 98, k = 10, method = "rhodcca", nu = 0)
}
\arguments{
\item{x1}{A vector containing univariate time series.}

\item{x2}{A vector containing univariate time series.}

\item{y}{A vector containing univariate time series.}

\item{w}{An integer value indicating the window size \eqn{w < length(y)}.
If \eqn{w = length(y)}, will be computed the function will not slide.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{method}{A character string indicating which correlation coefficient is to be used. If method = "rhodcca" (default) the dmc coefficient is generated from the DCCA coefficient. If method = "dmca", the dmc coefficient is generated from the DMCA coefficient.}

\item{nu}{An integer value. See the DCCA package.}
}
\value{
A list containing "w", "dmc", "yx1", "yx2", "x1x2".
}
\description{
This function generates DMC Coefficient of three time series with sliding windows approach.
}
\details{
This function include following measures: w, timescale, dmc and cross-correlation between: yx1, yx2, x1x2
}
\examples{
x1 <- rnorm(100)
x2 <- rnorm(100)
y <- rnorm(100)
dmc.SlidingWindows(x1,x2,y,w=99,k=10,nu=0, method="rhodcca")
dmc.SlidingWindows(x1,x2,y,w=99,k=10,nu=0, method="dmca")

}
\references{
ZEBENDE, G.; SILVA-FILHO, A.M. Detrended multiple cross-correlation coefficient, Physica A 510, 91-97, 2018. doi="doi.org/10.1016/j.physa.2018.06.119".

GUEDES,E.F.;SILVA-FILHO, A.M.; ZEBENDE, G.F. Detrended multiple cross-correlation coefficient with sliding windows approach. Physica A, 125990, 2021. doi="doi.org/10.1016/j.physa.2021.125990".
}
