% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gibbs_sampler.R
\name{print.SpaTopic}
\alias{print.SpaTopic}
\title{Print method for SpaTopic objects}
\usage{
\method{print}{SpaTopic}(x, ...)
}
\arguments{
\item{x}{An object of class "SpaTopic" returned by the SpaTopic_inference function}

\item{...}{Additional arguments passed to print methods (not used)}
}
\value{
No return value, called for side effect of printing
}
\description{
Provides a formatted summary of SpaTopic results when the object is printed.
This method displays key model metrics and explains how to access different components
of the model output.
}
\details{
The method displays:
  - Number of topics identified
  - Model perplexity (lower is better)
  - DIC (Deviance Information Criterion) for model comparison
  - A preview of the topic distributions across cell types
  - Instructions on how to access full results
}
\examples{
# If gibbs.res is a SpaTopic object:
# print(gibbs.res)
}
