% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spader.R
\name{Diversity}
\alias{Diversity}
\title{Estimation of species diversity (Hill numbers)}
\usage{
Diversity(data, datatype = c("abundance", "abundance_freq_count",
  "incidence_freq", "incidence_freq_count", "incidence_raw"), q = NULL)
}
\arguments{
\item{data}{a matrix/data.frame of species abundances/incidences.\cr}

\item{datatype}{type of input data, "abundance", "abundance_freq_count", "incidence_freq", "incidence_freq_count" or "incidence_raw". \cr}

\item{q}{a vector of nonnegative numbers specifying the diversity orders for which Hill numbers will be estimated. If \code{NULL}, then
Hill numbers will be estimated at order q from 0 to 3 with increments of 0.25.}
}
\value{
a list of seven objects: \cr\cr
\code{$Basic_data} for summarizing data information. \cr\cr
\code{$Species_richness} for showing various species richness estimates along with related statistics. \cr\cr
\code{$Shannon_index} and \code{$Shannon_diversity} for showing various Shannon index/diversity estimates. \cr\cr
\code{$Simpson_index} and \code{$Simpson_diversity} for showing two Simpson index/diversity estimates. \cr\cr
\code{$Hill_numbers} for showing Hill number (diversity) estimates of diversity orders specified in the argument \code{q}. \cr\cr
}
\description{
\code{Diversity}: Estimating a continuous diversity profile in one community including species rich-
ness, Shannon diversity and Simpson diversity). This function also supplies plots of empirical and
estimated continuous diversity profiles. Various estimates for Shannon entropy and the Gini-
Simpson index are also computed. All five types of data are supported: Type (1) abundance data
(datatype="abundance"), Type (1A) abundance-frequency counts
(datatype="abundance_freq_count"), Type (2) incidence-frequency data (datatype =
"incidence_freq"), Type (2A) incidence-frequency counts (datatype="incidence_freq_count"), and
Type (2B) incidence-raw data (datatype="incidence_raw"); see \code{SpadeR-package} details for data input formats.
}
\examples{
\dontrun{
data(DiversityData)
# Type (1) abundance data 
Diversity(DiversityData$Abu,"abundance",q=c(0,0.5,1,1.5,2))
# Type (1A) abundance-frequency counts data 
Diversity(DiversityData$Abu_count,"abundance_freq_count",q=seq(0,3,by=0.5))
# Type (2) incidence-frequency data 
Diversity(DiversityData$Inci,"incidence_freq",q=NULL)
# Type (2A) incidence-frequency counts data 
Diversity(DiversityData$Inci_freq_count,"incidence_freq_count",q=NULL)
# Type (2B) incidence-raw data 
Diversity(DiversityData$Inci_raw,"incidence_raw",q=NULL)
}
}
\references{
Chao, A., and Chiu, C. H. (2012). Estimation of species richness and shared species richness. In N. Balakrishnan (ed). Methods and Applications of Statistics in the Atmospheric and Earth Sciences. p.76-111, Wiley, New York.\cr\cr
Chao, A. and Jost, L. (2015). Estimating diversity and entropy profiles via discovery rates of new species. Methods in Ecology and Evolution, 6, 873-882.\cr\cr
Chao, A., Wang, Y. T. and Jost, L. (2013). Entropy and the species accumulation curve: a novel estimator of entropy via discovery rates of new species. Methods in Ecology and Evolution 4, 1091-1110.\cr\cr
}

