% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseFunClust_data_generation.R
\name{cer}
\alias{cer}
\title{CER function}
\usage{
cer(P, Q)
}
\arguments{
\item{P}{first vector of cluster assignments (length n)}

\item{Q}{second vector of cluster assignments (length n)}
}
\value{
The CER index, which is a number between 0 and 1, and also equal to
1 - Rand index (Rand, 1971), a popular measure of the goodness of a
clustering.
}
\description{
Given two partitions P and Q, \code{cer(P, Q)} measures how well
they agree,
the lower the better. It is rigorously defined as the proportion of pairwise
disagreements in the two partitions (i.e., how many, out of all the possible
couples of elements in the sample, are localized in the same cluster in one
partition and in a different one in the other partition).
}
\examples{
set.seed(8988327)
x <- seq(0, 1, len = 500)
out <- generate.data.FV17(50, x)
result <- SparseFunClust(out$data, x, K = 2, do.alignment = FALSE)
cer(out$true.partition, result$labels)
}
\references{
Rand, W. M. (1971). Objective criteria for the evaluation of
clustering methods. Journal of the American Statistical association, 66(336),
846-850.
}
