% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialClustering.R
\name{spatialPropClustering}
\alias{spatialPropClustering}
\title{Cluster spatial data based on predicted cell proportions}
\usage{
spatialPropClustering(
  object,
  index.st,
  method = "graph",
  k.nn = 10,
  k.centers = 5,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with deconvoluted ST
datasets.}

\item{index.st}{Name or index of the dataset/slide already deconvoluted to be
clustered. If missing, all datasets already deconvoluted will be clustered.}

\item{method}{Clustering method. It can be \code{graph} (a nearest neighbor
graph is created and Louvain algorithm is used to detect communities) or
\code{k.means} (k-means algorithm is run with the specified number of
centers (\code{k.centers} parameter)).}

\item{k.nn}{An integer specifying the number of nearest neighbors to be used
during graph construction (10 by default). Only if
\code{method == "graph"}.}

\item{k.centers}{An integer specifying the number of centers for k-means
algorithm (5 by default). Only if \code{method == "k.means"}.}

\item{verbose}{Show informative messages during the execution (\code{TRUE} by
default).}
}
\value{
A \code{\linkS4class{SpatialDDLS}} object containing computed
clusters as a column in the slot \code{colData} of the
\code{\link[SpatialExperiment]{SpatialExperiment}} objects.
}
\description{
Cluster spatial transcriptomics data according to the cell proportions
predicted in each spot. It allows to segregate ST data into niches with
similar cell composition.
}
\examples{
\donttest{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 10,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(10)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(10)),
    Cell_Type = sample(x = paste0("CellType", seq(2)), size = 10,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE
) 
SDDLS <- genMixedCellProp(
  SDDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  num.sim.spots = 50,
  train.freq.cells = 2/3,
  train.freq.spots = 2/3,
  verbose = TRUE
) 
SDDLS <- simMixedProfiles(SDDLS) 
SDDLS <- trainDeconvModel(
  SDDLS,
  batch.size = 12,
  num.epochs = 5
) 
# simulating spatial data
ngenes <- sample(3:40, size = 1)
ncells <- sample(10:40, size = 1)
counts <- matrix(
  rpois(ngenes * ncells, lambda = 5), ncol = ncells,
  dimnames = list(paste0("Gene", seq(ngenes)), paste0("Spot", seq(ncells)))
)
coordinates <- matrix(
  rep(c(1, 2), ncells), ncol = 2
)
st <- SpatialExperiment::SpatialExperiment(
  assays = list(counts = as.matrix(counts)),
  rowData = data.frame(Gene_ID = paste0("Gene", seq(ngenes))),
  colData = data.frame(Cell_ID = paste0("Spot", seq(ncells))),
  spatialCoords = coordinates
)
SDDLS <- loadSTProfiles(
  object = SDDLS,
  st.data = st,
  st.spot.ID.column = "Cell_ID",
  st.gene.ID.column = "Gene_ID"
)
SDDLS <- deconvSpatialDDLS(
  SDDLS,
  index.st = 1
) 
SDDLS <- spatialPropClustering(SDDLS, index.st = 1, k.nn = 5)
}
  
}
\seealso{
\code{\link{plotTrainingHistory}} \code{\link{deconvSpatialDDLS}}
}
