% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-GET.R
\docType{methods}
\name{getStratName}
\alias{getStratName}
\alias{getStratName,Strategy-method}
\title{Get strategy function name from \code{Strategy}-object}
\usage{
getStratName(object, include.params = FALSE)

\S4method{getStratName}{Strategy}(object, include.params = FALSE)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{include.params}{If set to \code{TRUE}, the parameters used for strategy evaluation are included.}
}
\description{
Gets the strategy function name of an object of class \code{Strategy} that was used for strategy calculation. This function is for aesthetic purposes only and does not have any numerical relevance.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Get strategy function name from MA(200)-Strategy
getStratName(myStrat.MA) # returns "MA"
getStratName(myStrat.MA, include.params=TRUE) # returns "MA(200)"

##End(Not run)
}
