% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_calculate_hrscale.R
\name{e2e_calculate_hrscale}
\alias{e2e_calculate_hrscale}
\title{Calculate initial values of the scaling parameters for the fishing fleet model which link effort to harvest ratios.}
\usage{
e2e_calculate_hrscale(model)
}
\arguments{
\item{model}{R-list object generated by the e2e_read() function which defined the model configuration}
}
\value{
Dataframe of the effort-harvest ratio scaling parameter values for each guild
}
\description{
The scaling parameters convert the effort applied by each gear to each living resource guild in the model, into a harvest ratio (proportion of mass captured per day).
Effort is the product of activity and the relative power of each gear with respect to each guild.
}
\details{
In order to estimate these scaling parameters, data are needed for a 'calibration' time period when activity, catch and harvest ratio are all known.

The function assumes that the relevant model configuration has already been loaded using the e2e_read() function. It is expected that
this has loaded the array of power parameters (catch per unit activity by gear and guild during the calibration period) given in the file /Param/fishing_power_*.csv,
the corresponding activity in the file /Param/fishing_activity_*.csv, and the known harvest ratios of each guild in the file /Target/region_harvest_r_*.csv

The function returns rough estimates of the scaling parameters. These are only rough because they assume that the effort and resource biomass are distributed uniformly
over the model domain. Hence they should be used as initial estimates to be refined by optimization.

The scaling parameters are dispayed on the screen and saved in a dataframe. The values then need to be manually edited
into rows 12-21 (excluding the header row) of the file /Param/fishing_fleet_*.csv
}
\examples{
# Load the 2003-2013 version of the North Sea model supplied with the package and calculate
# scaling parameter values:
    model <- e2e_read("North_Sea", "2003-2013", quiet=FALSE)
    scale_values <- e2e_calculate_hrscale(model)
    scale_values
}
\seealso{
\code{\link{e2e_ls}} , \code{\link{e2e_read}}
}
