#' @title Example 3.9 from Generalized Linear Mixed Models: Modern Concepts, Methods and Applications by Walter W. Stroup(p-118)
#' @name   Exam3.9
#' @description Exam3.9 used to differentiate conditional and marginal binomial models with and without interaction for S2 variable.
#' @author \enumerate{
#'          \item  Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'          \item Adeela Munawar (\email{adeela.uaf@@gmail.com})
#'          }
#' @references \enumerate{
#' \item Stroup, W. W. (2012).
#'      \emph{Generalized Linear Mixed Models: Modern Concepts, Methods and Applications}.
#'        CRC Press.
#'  }
#' @seealso
#'    \code{\link{DataSet3.2}}
#'
#' @import parameters
#' @import emmeans
#' @importFrom MASS glmmPQL
#' @importFrom nlme lme
#'
#' @examples
#' #-----------------------------------------------------------------------------------
#' ## Binomial conditional GLMM without interaction, logit link
#' #-----------------------------------------------------------------------------------
#' library(MASS)
#' DataSet3.2$trt <- factor( x  =  DataSet3.2$trt )
#' DataSet3.2$loc <- factor( x  =  DataSet3.2$loc )
#'
#' Exam3.9.fm1   <-
#'   glmmPQL(
#'       fixed    =  S2/Nbin~trt
#'     , random   = ~1|loc
#'     , family   =  quasibinomial(link = "logit")
#'     , data     =  DataSet3.2
#'     , niter    = 10
#'     , verbose  = TRUE
#'   )
#' summary(Exam3.9.fm1)
#' library(parameters)
#' model_parameters(Exam3.9.fm1)
#'
#' #-------------------------------------------------------------
#' ##  treatment means
#' #-------------------------------------------------------------
#' library(emmeans)
#' emmeans(object = Exam3.9.fm1, specs = ~trt, type = "response")
#' emmeans(object = Exam3.9.fm1, specs = ~trt, type = "link")
#' emmeans(object = Exam3.9.fm1, specs = ~trt, type = "logit")
#'
#' ##--- Normal Approximation
#' library(nlme)
#' Exam3.9fm2 <-
#'   lme(
#'       fixed       = S2/Nbin~trt
#'     , data        = DataSet3.2
#'     , random      = ~1|loc
#'     , method      = c("REML", "ML")[1]
#'   )
#'
#' Exam3.9fm2
#' model_parameters(Exam3.9fm2)
#'
#' emmeans(object  = Exam3.9fm2, specs = ~trt)
#'
#'
#' ##---Binomial GLMM with interaction
#' Exam3.9fm3   <-
#'   glmmPQL(
#'       fixed       =  S2/Nbin~trt
#'     , random      = ~1|trt/loc
#'     , family      =  quasibinomial(link = "logit")
#'     , data        =  DataSet3.2
#'     , niter = 10
#'     , verbose = TRUE
#'   )
#' summary(Exam3.9fm3)
#' model_parameters(Exam3.9fm3)
#' emmeans(object = Exam3.9fm3, specs = ~trt)
#'
#'
#' ##---Binomial Marginal GLMM(assuming compound symmetry)
#' Exam3.9fm4   <-
#'   glmmPQL(
#'       fixed       =  S2/Nbin~trt
#'     , random      = ~1|loc
#'     , family      =  quasibinomial(link = "logit")
#'     , data        =  DataSet3.2
#'     , correlation =  corCompSymm(form = ~1|loc)
#'     , niter       = 10
#'     , verbose     = TRUE
#'   )
#' summary(Exam3.9fm4)
#' model_parameters(Exam3.9fm4)
#' emmeans(object  = Exam3.9fm4, specs  = ~trt)
#'
NULL
