% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnormtz.R
\name{dnormtz}
\alias{dnormtz}
\title{Density of a multivariate normal with Toeplitz variance matrix.}
\usage{
dnormtz(X, mu, acf, log = FALSE, method = c("gschur", "ltz"))
}
\arguments{
\item{X}{Vector of length \code{N} or \verb{N x n} matrix, of which each column is a multivariate observation.}

\item{mu}{Vector or matrix of mean values of compatible dimensions with \code{X}.  Defaults to all zeros.}

\item{acf}{Vector of length \code{N} containing the first column of the Toeplitz variance matrix.}

\item{log}{Logical; whether to return the multivariate normal density on the log scale.}

\item{method}{Which calculation method to use.  Choices are: \code{gschur} for a modified version of the Generalized Schur algorithm of Ammar & Gragg (1988), or \code{ltz} for the Levinson-Trench-Zohar method.  The former scales as \verb{O(N log^2 N)} whereas the latter scales as \code{O(N^2)} and should only be used for \code{N < 300}.}
}
\value{
Vector of \code{n} (log-)densities, one for each column of \code{X}.
}
\description{
Density of a multivariate normal with Toeplitz variance matrix.
}
\examples{
# simulate data
N <- 10 # length of each time series
n <- 3 # number of time series
theta <- 0.1
lambda <- 2
mu <- theta^2 * rep(1, N)
acf <- exp(-lambda * (1:N - 1))

X <- rnormtz(n, acf = acf) + mu

# evaluate log-density
dnormtz(X, mu, acf, log = TRUE)
}
