% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survdesc.R
\name{survdesc}
\alias{survdesc}
\title{High dimensional univariate cox proportional hazard analysis.}
\usage{
survdesc(m, n, survdur, event, aic = TRUE, data)
}
\arguments{
\item{m}{Starting column number form where study variables of high dimensional data will get selected.}

\item{n}{Ending column number till where study variables of high dimensional data will get selected.}

\item{survdur}{Column name of survival duration event, a string value. i.e. "os"}

\item{event}{Column name of survival event, a string value. i.e "death"}

\item{aic}{By default aic = FALSE, if aic = TRUE the function returns}

\item{data}{High dimensional data containing the survival, progression and genomic observations.}
}
\value{
A data set containing estimates for variables present in column m to n.
}
\description{
Given the dimension of variables and survival information the function performs uni-variate Cox PH.
}
\examples{
##
data(hnscc)
survdesc(m=10,n=50,survdur="os",event="death",aic=TRUE,data=hnscc)
##
}
