% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{skr_graph}
\alias{skr_graph}
\title{skr_graph}
\usage{
skr_graph(
  moments_df,
  statistics_factor_name,
  statistics_factor_name_breaks = NULL,
  statistics_factor_name_col = NULL,
  slope_distance = CONSTANTS$SKEW_UNIFORM_SLOPE_DISTANCE,
  intercept_distance = CONSTANTS$SKEW_UNIFORM_INTERCEPT_DISTANCE,
  output_path = NULL,
  dpi = 600
)
}
\arguments{
\item{moments_df}{moments data frame (mean, variance, skewness, kurtosis)}

\item{statistics_factor_name}{column of data use for colors discrimination}

\item{statistics_factor_name_breaks}{vector of factor levels of the
statistics_factor_name, same dimension than statistics_factor_name_col}

\item{statistics_factor_name_col}{vector of colors, same dimension than
statistics_factor_name_breaks}

\item{slope_distance}{slope of the theoretical distribution
law (default: slope = 1 intercept = 1.86 skew-uniform)}

\item{intercept_distance}{intercept of the theoretical distribution
law (default: slope = 1 intercept = 1.86 skew-uniform)}

\item{output_path}{The path to save the graph}

\item{dpi}{The dpi number to use when we generate png/jpg graph}
}
\value{
A graph instance
}
\description{
Graph of the SKR, compared to null model
}
\examples{

\donttest{

results <- TAD::launch_analysis_tad(
  weights = TAD::AB[, 5:102],
  weights_factor = TAD::AB[, c("Year", "Plot", "Treatment", "Bloc")],
  trait_data = log(TAD::trait[["SLA"]]),
  aggregation_factor_name = c("Year", "Bloc"),
  statistics_factor_name = (statistics_factor_name <- c("Treatment")),
  randomization_number = 100,
  slope_distance = (
    slope_distance <- TAD::CONSTANTS$SKEW_UNIFORM_SLOPE_DISTANCE
  ),
  intercept_distance = (
    intercept_distance <- TAD::CONSTANTS$SKEW_UNIFORM_INTERCEPT_DISTANCE
  )
)

graph <- TAD::skr_graph(
  moments_df = results$weighted_moments,
  statistics_factor_name = statistics_factor_name,
  statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
  statistics_factor_name_col = c("#1A85FF", "#D41159"),
  slope_distance = slope_distance,
  intercept_distance = intercept_distance
)

plot(graph)

output_path <- file.path(tempdir(), "outputs")
dir.create(output_path)
TAD::skr_graph(
  moments_df = results$weighted_moments,
  statistics_factor_name = statistics_factor_name,
  statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
  statistics_factor_name_col = c("#1A85FF", "#D41159"),
  slope_distance = slope_distance,
  intercept_distance = intercept_distance,
  dpi = 200,
  output_path = file.path(output_path, "moment_graph.png")
)

unlink(output_path, recursive = TRUE, force = TRUE)

}

}
