% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_TAAG.R
\name{cv.TAAG}
\alias{cv.TAAG}
\title{Leave-One-Out Cross Validation Error of a TAG or TAAG Process}
\usage{
cv.TAAG(object, TAAG.indicator  = FALSE)
}
\arguments{

\item{object}{object of class inheriting from "TAG" or "TAAG".}

\item{TAAG.indicator}{logical. If TRUE, the object is from TAAG; otherwise, from TAG.}

}
\description{
This function evaluates the leave-one-out cross validation errors of a TAG or TAAG process.
}
\value{
The values returned from the function is a list containing:
\item{CV}{Leave-one-out cross validation errors  in the original scale of y.}
\item{TCV}{Leave-one-out cross validation errors in the transformed scale.}
}
\references{
Lin, L.-H. and Joseph,  V. R. (2020) "Transformation and Additivity in Gaussian Processes",\emph{Technometrics}, 62, 525-535.  DOI:10.1080/00401706.2019.1665592.
}
\seealso{
  \code{\link{TAG}} and  \code{\link{TAAG}} for the estimates of the parameters in the TAG and TAAG, respectively.
}
\examples{
n <- 20
p <- 2
library(randtoolbox)
X <- sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)
par.TAG <- TAG(ini.TAG)
cv.scores <- cv.TAAG(par.TAG)
(CV.TAG <- cv.scores$CV)
(TCV.TAG <- cv.scores$TCV)
}
\keyword{Cross Validation}
\keyword{Model Validation}
