% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Param.norm.R
\name{Param.norm}
\alias{Param.norm}
\title{Estimate a Gaussian TAR model using Gibbs Sampler given the structural parameters.}
\usage{
Param.norm(Z, X, l, r, K, n.sim = 500, p.burnin = 0.2, n.thin = 3)
}
\arguments{
\item{Z}{The threshold series}

\item{X}{The series of interest}

\item{l}{The number of regimes.}

\item{r}{The vector of thresholds for the series \eqn{\{Z_t\}}.}

\item{K}{The vector containing the autoregressive orders of the \eqn{l} regimes.}

\item{n.sim}{Number of iteration for the Gibbs Sampler}

\item{p.burnin}{Percentage of iterations used for burn-in}

\item{n.thin}{Thinnin factor for the Gibbs Sampler}
}
\value{
The function returns the autoregressive coefficients matrix theta and variance weights \eqn{H}. Rows of the matrix theta represent regimes
}
\description{
This function estimate a Gaussian TAR model using Gibbs Sampler given the structural parameters, i.e. the number of regimes, thresholds and autoregressive orders.
}
\details{
The TAR model is given by \deqn{X_t=a_0^{(j)} + \sum_{i=1}^{k_j}a_i^{(j)}X_{t-i}+h^{(j)}e_t} when \eqn{Z_t\in (r_{j-1},r_j]} for som \eqn{j} (\eqn{j=1,\cdots,l}). 
the \eqn{\{Z_t\}} is the threshold process, \eqn{l} is the number of regimes, \eqn{k_j} is the autoregressive order in the regime \eqn{j}. \eqn{a_i^{(j)}} with \eqn{i=0,1,\cdots,k_j} denote the autoregressive coefficients, while \eqn{h^{(j)}} denote the variance weights. \eqn{\{e_t\}} is the Gaussian white noise process \eqn{N(0,1)}.
}
\examples{
 # Example 1, TAR model with 2 regimes
Z<-arima.sim(n=500,list(ar=c(0.5)))
l <- 2
r <- 0
K <- c(2,1)
theta <- matrix(c(1,-0.5,0.5,-0.7,-0.3,NA), nrow=l)
H <- c(1, 1.5)
X <- simu.tar.norm(Z,l,r,K,theta,H)
# res <- Param.norm(Z,X,l,r,K)

# Example 2, TAR model with 3 regimes
Z<-arima.sim(n=300, list(ar=c(0.5)))
l <- 3
r <- c(-0.6, 0.6)
K <- c(1, 2, 1)
theta <- matrix(c(1,0.5,-0.5,-0.5,0.2,-0.7,NA, 0.5,NA), nrow=l)
H <- c(1, 1.5, 2)
X <- simu.tar.norm(Z, l, r, K, theta, H)
# res <- Param.norm(Z,X,l,r,K)
}
\references{
Nieto, F. H. (2005), \emph{Modeling Bivariate Threshold Autoregressive Processes in the Presence of Missing Data}. Communications in Statistics. Theory and Methods, 34; 905-930
}
\seealso{
\code{\link{LS.norm}}
}
\author{
Hanwen Zhang <hanwenzhang at usantotomas.edu.co>
}
