% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_calculations.R
\name{loss}
\alias{loss}
\title{Turner loss function for a list of groups (lists) of persistence diagrams.}
\usage{
loss(
  diagram_groups,
  dist_mats,
  dims,
  p,
  q,
  distance,
  sigma,
  rho,
  num_workers,
  group_sizes
)
}
\arguments{
\item{diagram_groups}{groups (lists/vectors) of persistence diagrams, stored as lists of a data frame and
an index of the diagram in all the diagrams across all groups.}

\item{dist_mats}{distance matrices between all possible pairs of persistence diagrams across and within groups
storing the current distances which have been pre-computed.}

\item{dims}{a numeric vector of which homological dimensions in which the loss function is to be computed.}

\item{p}{a number representing the wasserstein parameter, at least 1, and if Inf then the bottleneck distance is calculated.}

\item{q}{a finite number at least 1.}

\item{distance}{a string which determines which type of distance calculation to carry out, either "wasserstein" (default) or "fisher".}

\item{sigma}{the positive bandwidth for the persistence Fisher distance.}

\item{rho}{the approximation heuristic for Fisher information metric, results in sequential computation.}

\item{num_workers}{the number of cores used for parallel computation.}

\item{group_sizes}{for when using precomputed distance matrices.}
}
\value{
the numeric value of the Turner loss function.
}
\description{
An internal function to calculate the normalized sum of within-group exponentiated distances 
between pairs of persistence diagrams (stored as data frames)
for an arbitrary number of groups in parallel. Note that this function may run
into memory issues for large numbers of diagrams.
}
\details{
The Turner loss function is described in Robinson and Turner 2017
(\url{https://link.springer.com/article/10.1007/s41468-017-0008-7}), and is used
in the `permutation_test` function to describe how well-separated a particular
grouping of persistence diagrams is. When the `distance` parameter is "fisher",
`sigma` must not be NULL.
}
\references{
Robinson T, Turner K (2017). "Hypothesis testing for topological data analysis." \url{https://link.springer.com/article/10.1007/s41468-017-0008-7}.
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
\keyword{internal}
