% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data.tdcm}
\alias{data.tdcm}
\alias{data.tdcm01}
\alias{data.tdcm02}
\alias{data.tdcm03}
\alias{data.tdcm04}
\alias{data.tdcm05}
\title{Several data sets for the 'tdcm' package.}
\format{
\code{data.tdcm01} is simulated sample data that has two time points, four
attributes, twenty items, one group of size 1000, and a single Q-matrix. The
format is a list of two:
\itemize{
\item \code{data}: a data frame of binary item responses
\item \code{q.matrix}: a data frame specifying the Q-matrix
}

\code{data.tdcm02} is simulated data that has three time points, two
attributes, ten items, one group of size 2500, and a single Q-matrix. The
format is a list of two:
\itemize{
\item \code{data}: a data frame of binary item responses
\item \code{q.matrix}: a data frame specifying the Q-matrix
}

\code{data.tdcm03} is simulated data that has three time points, two
attributes, one group of size 1500, and three different ten-item Q-matrices
for each time point. Anchor items are specified as items 1/1/21 and items
14/24. The format is a list of five:
\itemize{
\item \code{data}: a data frame of binary item responses
\item \code{q.matrix.1}: a data frame specifying the Q-matrix for the first time point
\item \code{q.matrix.2}: a data frame specifying the Q-matrix for the second time point
\item \code{q.matrix.3}: a data frame specifying the Q-matrix for the third time point
\item \code{q.matrix.stacked}: data frame specifying the combined Q-matrix for all time
points
}

\code{data.tdcm04} is simulated data that has two time points, four
attributes, twenty items, two group of size 800 and 900, respectively, and a
single Q-matrix. The format is a list of three:
\itemize{
\item \code{data}: a data frame of binary item responses
\item \code{q.matrix}: a data frame specifying the Q-matrix
\item \code{groups}: a vector specifying the examinee group memberships
}

\code{data.tdcm05} is simulated data that has two has one time point, four
attributes, and twenty items. For use with the 1-PLCDM. The format is a list
of two:
\itemize{
\item \code{data}: a data frame of binary item responses
\item \code{q.matrix}: a data frame specifying the Q-matrix
}
}
\usage{
data.tdcm01

data.tdcm02

data.tdcm03

data.tdcm04

data.tdcm05
}
\description{
Several data sets for the 'tdcm' package.
}
\examples{
\donttest{
## Example 1: T = 2, A = 4
data(data.tdcm01, package = "TDCM")
data <- data.tdcm01$data
q.matrix <- data.tdcm01$q.matrix
model <- TDCM::tdcm(data, q.matrix, num.time.points = 2)
}
}
\keyword{data}
