% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdcm.compare.R
\name{tdcm.compare}
\alias{tdcm.compare}
\title{Comparing the fit of two TDCMs}
\usage{
tdcm.compare(model1, model2)
}
\arguments{
\item{model1}{a \code{gdina} object returned from the \code{\link{tdcm}} or \code{\link{mg.tdcm}} function.}

\item{model2}{a second \code{gdina} object returned from the \code{\link{tdcm}} or \code{\link{mg.tdcm}} function}
}
\value{
This function returns a data frame with model fit statistics (AIC/BIC) and results from a likelihood ratio or deviance test.
}
\description{
Provides a comparison of two TDCMs. Can be used to compare different measurement models or assess measurement invariance over time or over groups in the multigroup TDCM case. Only accepts two models.
}
\note{
\itemize{
\item Currently, this function currently accepts two models for comparison.
\item Both models must be fit to the same item responses and Q-matrix.
\item The function will provide results for two non-nested models. Please ensure that models are nested before interpreting the likelihood ratio test for nested models.
\item The likelihood ratio test is not valid for some model comparisons (e.g., LCDM vs DINA) because of model constraints.
}
}
\examples{
\donttest{
## Example 1: T = 2, A = 4
data(data.tdcm01, package = "TDCM")
dat1 <- data.tdcm01$data
qmat1 <- data.tdcm01$q.matrix

# estimate TDCM with invariance assumed and full LCDM
m1 <- TDCM::tdcm(dat1, qmat1, num.time.points = 2, invariance = TRUE, rule = "GDINA")

# estimate TDCM with invariance not assumed
m2 <- TDCM::tdcm(dat1, qmat1, num.time.points = 2, invariance = FALSE, rule = "GDINA")

# compare models to assess measurement invariance.
TDCM::tdcm.compare(m1, m2)
}
}
