% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trop.hyper.dist.R
\name{trop.hyper.dist}
\alias{trop.hyper.dist}
\title{Calculate the tropical distance to a max-tropical hyperplane}
\usage{
trop.hyper.dist(O, x0, tadd = max)
}
\arguments{
\item{O}{normal vector of a tropical hyperplane; numeric vector}

\item{x0}{point of interest; numeric vector}

\item{tadd}{function; max indicates max-plus addition, min indicates
min-plus addition. Defaults to max}
}
\value{
tropical distance to max-plus tropical hyperplane
}
\description{
Calculate the tropical distance to a max-tropical hyperplane
}
\examples{
O <-c(0,-1,-1)
x0 <- c(0,-2,-8)
trop.hyper.dist(O,x0)
trop.hyper.dist(O,x0,tadd=min)
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
