% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tropical.PCA.R
\name{trop.tri.plot.w.pts}
\alias{trop.tri.plot.w.pts}
\title{Plotting PCA-derived tropical triangles}
\usage{
trop.tri.plot.w.pts(S, D)
}
\arguments{
\item{S}{inital set of vertices for the tropical triangle}

\item{D}{matrix of data where each row is an observation in the tropical
projective torus}
}
\value{
rendering of tropical triangle saved to current directory
}
\description{
This function conducts tropical PCA to find the best fit tropical triangle
given data defined in the tropical projective torus. It employs the vertex
HAR with extrapolation sampler to sample points to determine the vertices of
the tropical triangle.
}
\examples{
\donttest{
s <- 3 #number of vertices.  Here it is a tropical triangle
d <- 3 ## dimension
N <- 100 ## sample size
V <- matrix(c(100, 0, 0, 0, 100, 0, 0, 0, 100, -100, 0, 0, 0, -100, 0, 0, 0, -100), 6, 3, TRUE)
D <- matrix(rep(0, N*d), N, d)
D[, 1] <- rnorm(N, mean = 5, sd = 5)
D[, 2] <- rnorm(N, mean = -5, sd = 5)
D[, 3] <- rnorm(N, mean = 0, sd = 5)
index <- sample(1:N, s)
S <- D[index,]
res <- tropical.PCA.Polytope(S, D, V, I = 1000,50)
DD <- pre.pplot.pro(res[[2]], res[[3]])
trop.tri.plot.w.pts(normaliz.ultrametrics(res[[2]]), DD)}
}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
