% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropical.centroid.MH.R
\name{tropical.centroid.MH}
\alias{tropical.centroid.MH}
\alias{trop.centroid.MH}
\alias{trop.centroid.MH.square}
\title{Centroid-based sampling using Metropolis filter}
\usage{
trop.centroid.MH(D, x0, m, s, n, I = 50, tadd = max)

trop.centroid.MH.square(D, x0, m, s, n, I = 50, tadd = max)
}
\arguments{
\item{D}{matrix of vertices of a tropical polytope; each row is a vertex}

\item{x0}{initial point for sampler, numeric vector}

\item{m}{location parameter; numeric vector}

\item{s}{scale parameter; scalar}

\item{n}{number of points to sample}

\item{I}{states in Markov chain}

\item{tadd}{function; max indicates max-plus addition, min indicates
min-plus addition. Defaults to max}
}
\value{
matrix of n sampled points where each point is a row
}
\description{
This function samples points on a tropical line segment about a location
parameter for a given scale parameter defined in terms of tropical distance
}
\examples{
D1 <-matrix(c(0,0,0,0,10,0,0,0,10),3,3,TRUE)
D2 <-matrix(c(0,10,10,0,10,0,0,0,10),3,3,TRUE)
x0 <- c(0,0,0)
m1<-c(0,5,5)
m2<-c(0,-1,1)
s<-1
n<-10
trop.centroid.MH(D1, x0, m1, s, n, I=50)
trop.centroid.MH.square(D1, x0,m1, s, n, I=50)
trop.centroid.MH(D2, x0, m1, s, n, I=50,tadd=min)
trop.centroid.MH.square(D2, x0,m2, s, n, I=50,tadd=min)
}
\references{
Yoshida, Ruriko, Keiji Miura and David Barnhill (2022). Hit and
Run Sampling from Tropically Convex Sets.
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
