% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{diff_survival_time_quantile}
\alias{diff_survival_time_quantile}
\title{diff_survival_time_quantile}
\usage{
diff_survival_time_quantile(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control parameters}
}
\value{
A difference in a survival time quantile across treatment arms.
}
\description{
Computes the difference in the quantile of a survival function
across treatment groups.
}
\details{
Computes the survival function quantile for the treatment and
control arms and returns the difference.
}
\examples{
requireNamespace( "survival", quiet = TRUE )
N <- 200
df <- data.frame( y = survival::Surv( runif( min = 0, max = 20, n = N ),
                            sample( c(0,1), size = N, prob = c(0.2,0.8), replace = TRUE ) ),
                  trt = sample( c('Control','Experimental'), size = N,
                                prob = c(0.4,0.6), replace = TRUE ) )

## Compute difference in median survival time between Experimental arm and
## Control arm.  It is not actually necessary to provide the value for the
## time_var, trt_var, trt_control, and percentile parameters because these
## values are all equal to their default values. The value are explicitly
## provided here simply for clarity.
ex1 <- diff_survival_time_quantile( data = df,
                                    scoring_function_parameters = list( trt_var = "trt",
                                    trt_control = "Control",
                                    percentile = 0.50 ) )

## Compute difference in Q1 survival time. In this example the default value
## for all scoring function parameters are used except percentile, which here
## takes the value 0.25.
ex2 <- diff_survival_time_quantile( data = df,
                                    scoring_function_parameters = list( percentile = 0.25 ) )
}
\seealso{
\link{TSDT}, \link{survival_time_quantile}, \link[survival]{Surv},
\link[survival]{coxph}, \link[survival]{survfit}, \link[survival]{survreg},
\link[survival]{predict.coxph}, \link[survival]{predict.survreg}
}
