% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_helper_functions.R
\name{get_covariates}
\alias{get_covariates}
\title{get_covariates}
\usage{
get_covariates(data, scoring_function_parameters)
}
\arguments{
\item{data}{A data.frame containing in-bag or out-of-bag data}

\item{scoring_function_parameters}{A list of named elements containing control
parameters and other data required by the scoring function}
}
\value{
A data.frame of covariates.
}
\description{
Returns the covariate variables in the in-bag or out-of-bag data.
}
\details{
If the user provides a covariate_vars parameter in the list of
scoring_function_parameters this function will return the variables specified
by that parameter. If the user specifies a covariate_cols parameter in the list of
scoring_function_parameters the function returns the columns in data indexed
by that parameter. Otherwise, NULL is returned.
}
\examples{
## Create an example data.frame
df <- data.frame( y <- 1:5 )
names( df ) <- "y"
df$time <- 10:14
df$time2 <- 20:24
df$event <- sample( c(0:1), size = 5, replace = TRUE )
df$trt <- sample( c("Control","Treatment"), size = 5, replace = TRUE )
df$x1 <- runif( n = 5 )
df$x2 <- LETTERS[1:5]

## Select the covariate variables by name
get_covariates( df, scoring_function_parameters = list( covariate_vars = c("x1","x2") ) )

## Select the covariate variables by column index
get_covariates( df, scoring_function_parameters = list( covariate_cols = c(6:7) ) )
}
\seealso{
\link{get_y}, \link{get_trt}
}
