% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiWaveAnalisysParallel.R
\name{MultiWaveAnalysis}
\alias{MultiWaveAnalysis}
\title{Generate a MultiWave analysis}
\usage{
MultiWaveAnalysis(
  series,
  f,
  lev = 0,
  features = c("Var", "Cor", "IQR", "PE", "DM"),
  nCores = 0
)
}
\arguments{
\item{series}{Sample from the population (array of three dimensions
[dim, length, cases]}

\item{f}{Selected wavelet filter for the analysis. To see the available
filters use the function \code{\link{availableFilters}}}

\item{lev}{Wavelet decomposition level by default is selected using the
"conservative" strategy. See \code{\link{chooseLevel}} function. Must
be a positive integer (including 0 to auto-select the level)}

\item{features}{It allows to select the characteristics to be calculated for
the analysis. To see the available features use the function
\code{\link{availableFeatures}}}

\item{nCores}{Determines the number of processes that will be used in the
function, by default it uses all but one of the system cores. Must be
a positive integer, where 0 corresponds to the default behavior}
}
\value{
A multivariate analysis with the characteristics indicated in the
parameter features. This is an object of class MultiWaveAnalysis with
contains
* Features: A list with the computed features
* StepSelection: A selection with the most discriminant features
\code{\link{StepDiscrim}}
* Observations: Number of total observations
* NLevels: Number of levels selected for the decomposition process
* Filter: Filter used in the decomposition process
}
\description{
Generates a multivariate analysis by calculating a series of features from
the result of applying MODWT to the input data.
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
MWA <- MultiWaveAnalysis(ECGExample,
  f = "haar", lev = 0,
  features = c("Var", "Cor"), nCores = 0
)
}

}
\seealso{
\itemize{
\item \code{\link{availableFilters}}
\item \code{\link{availableFeatures}}
}
}
