% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastSampEn_R.R
\name{FastSampEn_R}
\alias{FastSampEn_R}
\title{FastSampEn_R}
\usage{
FastSampEn_R(TS, dim = 2, lag = 1, r = 0.15 * sd(TS))
}
\arguments{
\item{TS}{- given time series}

\item{dim}{- dimension of given time series, default value is 2}

\item{lag}{- downsampling, default value is 1}

\item{r}{- radius of searched areas, default value is 0.15*sd(TS)}
}
\description{
This function computes fast sample entropy of given time series. It is implemented in R.
}
\examples{
timser <- rnorm(2000)
FastSampEn_R(timser)
FastSampEn_R(timser, r = 0.1*sd(timser))
FastSampEn_R(timser, dim = 3, r = 0.1*sd(timser))

}
\keyword{FastSampEn}
\keyword{R}
\keyword{entropy}
\keyword{fast}
\keyword{sample}
