% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATSP.R
\name{ATSP}
\alias{ATSP}
\alias{as.ATSP}
\alias{as.ATSP.matrix}
\alias{as.ATSP.dist}
\alias{print.ATSP}
\alias{n_of_cities.ATSP}
\alias{labels.ATSP}
\alias{image.ATSP}
\alias{as.matrix.ATSP}
\title{Class ATSP -- Asymmetric traveling salesperson problem}
\usage{
ATSP(x, labels = NULL, method = NULL)

as.ATSP(x)

\method{as.ATSP}{matrix}(x)

\method{as.ATSP}{dist}(x)

\method{print}{ATSP}(x, ...)

\method{n_of_cities}{ATSP}(x)

\method{labels}{ATSP}(object, ...)

\method{image}{ATSP}(x, order, col = gray.colors(64), ...)

\method{as.matrix}{ATSP}(x, ...)
}
\arguments{
\item{x, object}{an object (a square matrix) to be converted into an
\code{ATSP} or, for the methods, an object of class \code{ATSP}.}

\item{labels}{optional city labels. If not given, labels are taken from
\code{x}.}

\item{method}{optional name of the distance metric.}

\item{...}{further arguments are passed on.}

\item{order}{order of cities as an integer vector or an object of class
\code{TOUR}.}

\item{col}{color scheme for image.}
}
\value{
\itemize{
\item \code{ATSP()} returns \code{x} as an object of class \code{ATSP}.
\item \code{n_of_cities()} returns the number of cities in \code{x}.
\item \code{labels()} returns a vector with the names of the cities in \code{x}.
}
}
\description{
Constructor to create an instance of the asymmetric traveling salesperson
problem (ATSP) and some auxiliary methods.
}
\details{
Objects of class \code{ATSP} are internally represented by a matrix (use
\code{as.matrix()} to get just the matrix).

ATSPs can be transformed into (larger) symmetric TSPs using
\code{\link[=reformulate_ATSP_as_TSP]{reformulate_ATSP_as_TSP()}}.
}
\examples{
data <- matrix(runif(10^2), ncol = 10, dimnames = list(1:10, 1:10))

atsp <- ATSP(data)
atsp

## use some methods
n_of_cities(atsp)
labels(atsp)

## calculate a tour
tour <- solve_TSP(atsp, method = "nn")
tour

tour_length(tour)

image(atsp, tour)
}
\seealso{
Other TSP: 
\code{\link{Concorde}},
\code{\link{ETSP}()},
\code{\link{TSP}()},
\code{\link{TSPLIB}},
\code{\link{insert_dummy}()},
\code{\link{reformulate_ATSP_as_TSP}()},
\code{\link{solve_TSP}()}
}
\author{
Michael Hahsler
}
\concept{TSP}
\keyword{classes}
