% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_io.r
\name{mlm_io}
\alias{mlm_io}
\title{Subset sliding windows of data}
\usage{
mlm_io(sw)
}
\arguments{
\item{sw}{A numeric matrix with sliding windows of time series data
as returned by \code{\link{sw}}.}
}
\value{
A list with input and output datasets.
}
\description{
Function subsets sliding windows of data into input and output datasets to be
passed to machine-learning methods.
}
\details{
When \code{sw} has \code{k} columns (sliding windows of size \code{k}),
the input dataset contains the first \code{k-1} columns and the output dataset
contains the last column of data.
}
\examples{

data(CATS)
swin <- sw(CATS[,1],5)
d <- mlm_io(swin)

}
\references{
E. Ogasawara, L. C. Martinez, D. De Oliveira, G. Zimbrao, G. L. Pappa, and M. Mattoso, 2010,
Adaptive Normalization: A novel data normalization approach for non-stationary time series, 
Proceedings of the International Joint Conference on Neural Networks.
}
\seealso{
Other transformation methods: 
\code{\link{Diff}()},
\code{\link{LogT}()},
\code{\link{WaveletT}()},
\code{\link{emd}()},
\code{\link{mas}()},
\code{\link{outliers_bp}()},
\code{\link{pct}()},
\code{\link{train_test_subset}()}
}
\author{
Rebecca Pontes Salles
}
\concept{transformation methods}
\keyword{internal}
\keyword{outlier}
\keyword{removal}
\keyword{series}
\keyword{time}
