% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluating_subclasses.r
\name{MSE_eval}
\alias{MSE_eval}
\alias{NMSE_eval}
\alias{RMSE_eval}
\alias{MAPE_eval}
\alias{sMAPE_eval}
\alias{MAXError_eval}
\alias{AIC_eval}
\alias{BIC_eval}
\alias{AICc_eval}
\alias{LogLik_eval}
\title{Prediction/modeling quality metrics}
\usage{
MSE_eval()

NMSE_eval(eval_par = list(train.actual = NULL))

RMSE_eval()

MAPE_eval()

sMAPE_eval()

MAXError_eval()

AIC_eval()

BIC_eval()

AICc_eval()

LogLik_eval()
}
\arguments{
\item{eval_par}{List of named parameters required by \code{\link{NMSE}} such as \code{train.actual}.}
}
\value{
An object of class \code{evaluating}.
}
\description{
Constructors for the \code{evaluating} class representing a time series prediction
or modeling fitness quality evaluation based on particular metrics.
}
\section{Error metrics}{

	MSE_eval: Mean Squared Error.


	NMSE_eval: Normalised Mean Squared Error.


	RMSE_eval: Root Mean Squared Error.


	MAPE_eval: Mean Absolute Percentage Error.


	sMAPE_eval: Symmetric Mean Absolute Percentage Error.


	MAXError_eval: Maximal Error.
}

\section{Fitness criteria}{

	AIC_eval: Akaike's Information Criterion.


	BIC_eval: Schwarz's Bayesian Information Criterion.


	AICc_eval: Second-order Akaike's Information Criterion.


	LogLik_eval: Log-Likelihood.
}

\seealso{
Other constructors: 
\code{\link{ARIMA}()},
\code{\link{LT}()},
\code{\link{evaluating}()},
\code{\link{modeling}()},
\code{\link{processing}()},
\code{\link{tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{constructors}
\keyword{evaluation}
\keyword{metric}
\keyword{quality}
