% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_data.R
\name{make_data}
\alias{make_data}
\title{Create data object for use with the process model}
\usage{
make_data(
  input,
  options = standard_options,
  globals = standard_globals,
  bounds = list(alpha = NULL, beta = NULL),
  groups = c(),
  verbose = FALSE
)
}
\arguments{
\item{input}{The forcing data object created by a call to \code{get_input()}, see specification in its help page}

\item{options}{An options list for running the model, see \code{options} help page}

\item{globals}{Optional parameter specifying global variables used in the simulation, see \code{standard_globals} help page}

\item{bounds}{Optional parameter specifying the upper and lower bounds of the model's parameters, see \code{make_data()}. Bounds for additional parameters included in the statistical model need to be specified here. Bounds of the process model parameters can also be modified from their default values.}

\item{groups}{Optional parameter specifying the groups of process model parameters}

\item{verbose}{Print out a log detailing checks}
}
\value{
A ttr data object, a list with the following elements:
\item{PGF}{Function used by LaplacesDemon for generating initial values.
}
\item{options}{Options as specified in the \code{options} and \code{standard_options} help pages
}
\item{globals}{Globals as specified in the \code{standard_globals} help page
}
\item{n.sites}{Number of sites
}
\item{n.species}{Number of species
}
\item{n.time}{Number of timesteps
}
\item{n.parm}{Number of parameters to be fitted
}
\item{n.parm.a}{Number of per-process parameters
}
\item{n.parm.b}{Number of per-species parameters
}
\item{parm.names}{Names of all parameters for this model configuration
}
\item{parm.names.a}{Names of per-process parameter names
}
\item{parm.names.b}{Names of per-species parameter names
}
\item{mon.names}{Required by LaplacesDemon, always set to "LP"
}
\item{out}{Names of the response variables returned by \code{run_ttr()}
}
\item{out.dimnames}{Dimension names for the output returned by \code{run_ttr()}
}
\item{out.dim}{Dimensions for the output returned by \code{run_ttr()}
}
\item{dimnames.beta}{Dimension names for the ttr parameters object produced by \code{get_parms()}
}
\item{bounds}{Bounds for all process model parameters
}
\item{timeseries}{See \code{get_input()}
}
\item{timeinvariant}{See \code{get_input()}
}
\item{y}{observations from \code{get_input()} cast to a matrix
}
\item{lonlat}{a matrix with lon and lat columns for the nsites rows
}
\item{pos.oe}{Indices of observation error parameters
}
\item{pos.pe}{Indices of process error parameters
}
\item{parm.trap.groups}{Representation of parameters that form a group for the trapezoid functions
}
\item{arguments}{The unprocessed arguments to this function, excluding data
}
}
\description{
This function creates an object representing a configuration of the process model including forcing data. 
             This object is used by \code{run_ttr()}.
}
\details{
The data structure produced in this function can be handed to an external parameter
         estimation algorithm e.g. LaplacesDemon or DEoptim to fit the model.

The bounds of the process model's parameters need to be defined.
The user can supply these to \code{make_data()} or accept the default 
values returned by a call to \code{make_data()}. Different model variants use 
different parameters and a call to \code{make_data()} returns the default bounds for the 
model variant specified in \code{options}. 

bounds is a list of two lists; one for alpha (per-process) parameters and 
one for beta (per-species) parameters. The list bounds is formatted as: 
bounds = list(alpha = list(alpha_parameter = (lower, upper)), 
beta = list(beta_parameter = c(lower, upper))), where `upper` specifies
the maximum value a process model parameter can take on, and 
`lower` is the corresponding minimum.

The external parameter estimation algorithm should then take Data$bounds[,1] as 
lower and Data$bounds[,2] as the upper bounds.

In case the user does not wish to estimate some of the parameters in the 
external optimisation process, the upper and lower bound of a parameter 
should be set to the same numeric value. In this case, the parameter will 
not be part of the Data$bounds matrix passed to the external parameter estimation
algorithm, and its value is set internally in the \code{get_parms()} function.

For any group of parameters, e.g., CU_Ns_1 and CU_Ns_2, setting any one 
of the parameters to c(NA, NA) will set the whole group of parameters to 
a constant value that will negate the influence of this parameter group on the 
process model. This effectively switches off the effect of these parameters 
on the model's processes and removes them from Data$bounds. The constant 
values the parameters are set to can be observed by inspecting the output 
of \code{get_parms()} for a Data object.

The names of the parameters are written as YY_XX_i, where YY specifies the
process being considered and XX the environmental driver and i the parameter
number in the step or trapezoid function, e.g. CU_swc_1 and CU_swc_2 specify
how CU (carbon uptake) is influenced by swc (soil water content) and 1 and 2
specify the lower and upper parameters of the step function.

An example for specifying all process bounds for a Model run with the 
standard options is given in the object `standard_bounds`.
}
\examples{
#some dummy data as input
input_data <- get_input(
observations = c(1),
tcur = c(1),
tnur = c(1),
tgrowth = c(1),
tloss = c(1),
seconds = c(1),
lon = c(1),
lat = c(1),
rsds = c(1),
catm = c(1),
pet = c(1),
rain = c(1),
wp = c(1),
fc = c(1)
)
data <- make_data(
  input = input_data,
  options = standard_options,
  globals = standard_globals,
  bounds = list(
    alpha = list(
      #defining a new parameter, e.g. as part of a model function
      my_parameter = c(1,2),
      #overwriting a standard bound
      scale = c(0,500)
    ),
    #no more parameters than needed for the process model in beta, for these standard values.
    beta = list()
  )
)
#all standard values
data <- make_data(input_data, standard_options)
}
