% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FORM.R
\name{FORM}
\alias{FORM}
\title{First Order Reliablity Method}
\usage{
FORM(
  lsf,
  lDistr,
  n_optim = 10,
  loctol = 0.01,
  optim_type = "rackfies",
  debug.level = 0
)
}
\arguments{
\item{lsf}{objective function with limit state function in form of \code{function(R,E) {R-E}}. Supplied by a SYS_ object, do not supply yourself.}

\item{lDistr}{list ob distribiutions regarding the distribution object of TesiproV. Supplied by a SYS_ object, do not supply yourself.}

\item{n_optim}{number of opimaziationcycles (not recommended/need for lagrangian algorithms).}

\item{loctol}{Tolerance of the local solver algorithm}

\item{optim_type}{Optimaziationtypes. Available: Augmented Lagrangian Algorithm (use: "auglag"),
Rackwitz-Fissler Algorithm (use: "rackfies").}

\item{debug.level}{If 0 no additional info if 2 high output during calculation}
}
\value{
The results will be provided within a list with the following objects.

beta HasoferLind Beta Index

pf probablity of failure

u_points solution points

dy gradients
}
\description{
Method to calculate failure probability for structural engineering using approximation of limit state function
with linear part.
}
\references{
HASOFER AM, LIND NC. An exact and invarient first order reliability format. J Eng Mech Div Proc ASCE 1974;100(1):111–21.

Rackwitz-Fiessler: RACKWITZ R., FIESSLER B. Structural reliability under combined random load sequences. Comput Struct 1978;9(5), S. 489–94.

Optimised algorithm: YPMA, J., JOHNSON, S.G., BORCHERS, H.W., EDDELBUETTEL, D., RIPLEY, B., HORNIK K., CHIQUET, J., ADLER, A., nloptr: R Interface to NLopt. R package. 2020. Version 1.2.2.

Spaethe, G.: Die Sicherheit tragender Baukonstruktionen, 2. Aufl. Wien: Springer, 1991. – ISBN 3-211-82348-4
}
\author{
(C) 2021 - K. Nille-Hauf, T. Feiri, M. Ricker - Hochschule Biberach, Institut fuer Konstruktiven Ingenieurbau
}
