% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xdata_functions.R
\name{getXdataOfExcludedEntry}
\alias{getXdataOfExcludedEntry}
\title{(Internal) Translate item exclusion instructions into a constraint matrix-data}
\usage{
getXdataOfExcludedEntry(simulation_constants, exclude_index)
}
\arguments{
\item{simulation_constants}{a named list containing simulation constants.}

\item{exclude_index}{a named list containing item/set indices that need to be excluded.}
}
\value{
\code{\link{getXdataOfExcludedEntry}} returns
a named list containing a constraint matrix-data.
\itemize{
  \item{\code{xmat} The left-hand side multipliers on decision variables.}
  \item{\code{xdir} The relation operator.}
  \item{\code{xrhs} The right-hand side value.}
}
}
\description{
(Internal) Translate item exclusion instructions into a constraint matrix-data
}
\examples{
simulation_constants <- list(
  nv = 5,
  ni = 5,
  group_by_stimulus = FALSE
)
exclude_index <- list(
  i = c(1, 2)
)
\dontrun{
getXdataOfExcludedEntry(simulation_constants, exclude_index)
}
}
\keyword{internal}
