% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\docType{class}
\name{st_attrib-class}
\alias{st_attrib-class}
\alias{loadStAttrib}
\title{Load set/stimulus/passage attributes}
\usage{
loadStAttrib(object, item_attrib)
}
\arguments{
\item{object}{itemset-level attributes. Can be a \code{\link{data.frame}} or the file path of a .csv file.
The content should at least include an 'STID' column that matches with itemset IDs (the 'STID' column) of the \code{\linkS4class{item_attrib}} object.}

\item{item_attrib}{an \code{\linkS4class{item_attrib}} object. Use \code{\link{loadItemAttrib}} for this.}
}
\value{
\code{\link{loadStAttrib}} returns a \code{\linkS4class{st_attrib}} object.

\itemize{
  \item{\code{data}} a \code{\link{data.frame}} containing itemset-level attributes.
}
}
\description{
\code{\link{loadStAttrib}} is a data loading function for creating an \code{\linkS4class{st_attrib}} object.
\code{\link{loadStAttrib}} can read itemset-level attributes from a \code{\link{data.frame}} or a .csv file.
}
\examples{
## Read from data.frame:
itempool_reading   <- loadItemPool(itempool_reading_data)
itemattrib_reading <- loadItemAttrib(itemattrib_reading_data, itempool_reading)
stimattrib_reading <- loadStAttrib(stimattrib_reading_data, itemattrib_reading)

## Read from file: write to tempdir() for illustration and clean afterwards
f <- file.path(tempdir(), "stimattrib_reading.csv")
write.csv(stimattrib_reading_data, f, row.names = FALSE)
stimattrib_reading <- loadStAttrib(f, itemattrib_reading)
file.remove(f)

}
\seealso{
\code{\link{dataset_reading}} for examples.
}
