% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schottTest.R
\name{schottTest}
\alias{schottTest}
\title{Schott's Test for testing independency}
\usage{
schottTest(X, alpha = 0.05)
}
\arguments{
\item{X}{A numeric matrix or data frame containing the variables.}

\item{alpha}{The significance level for the test (default is 0.05).}
}
\value{
A data frame containing the test statistic, alpha value, p-value, and test result.
}
\description{
Performs Schott's test for the correlation matrix to assess if the correlation matrix is significantly different from an identity matrix.
}
\examples{
library(MASS)

n = 50 # Sample Size
p = 5
rho = 0.1
# Building a Covariance structure with Autoregressive structure
cov_mat <- covMatAR(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test
schottTest(data)

# Building a Covariance structure with Compound Symmetry structure
cov_mat <- covMatCS(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test
schottTest(data)

# Building a Covariance structure with Circular structure
cov_mat <- covMatC(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test
schottTest(data)


}
\references{
Schott, J. R.  (2005). Testing for complete independence in high dimensions, Biometrika, 92(4), 951–956.
}
