% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_r.R
\name{is_r}
\alias{is_r}
\title{Check if a character string contains valid R code}
\usage{
is_r(code)
}
\arguments{
\item{code}{A character string containing the R code to be checked.}
}
\value{
A logical value indicating whether the input code string contains valid R code or not.
}
\description{
This function takes a character string as input and attempts to parse it as R code using the
`parse` function. If the parsing is successful, the function returns TRUE, indicating that
the input string contains valid R code. If parsing fails, the function returns FALSE.
}
\examples{
# Valid R code
valid_code <- "x <- 5; y <- 10; z <- x + y"
is_r(valid_code)

# Invalid R code
invalid_code <- "x <- 5 + 'a'"
is_r(invalid_code)

}
