% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_lambda.R
\name{max_lambda}
\alias{max_lambda}
\title{Max lambda1 and lambda2 values}
\usage{
max_lambda(stand_formula, exposure, df, weight = 1)
}
\arguments{
\item{stand_formula}{A formula for standartization and DR, y ~ A + X, the outcome as a function of the exposure and covariates}

\item{exposure}{The treatment/exposure vector pf length n. Must be encoded 1 for treated and 0 for untreated.}

\item{df}{a data frame with columns for the outcome, exposure and covariates.}

\item{weight}{A numerical vector of length n, holding weights to adjust for missing subtyps, Default: 1}
}
\value{
a vector of two numeric values, the first element is the maximum possible lambda1 value and the second element is the maximum possible lambda2 value.
}
\description{
In order to perform the sensitivity analysis, the researcher must choose which values of lambda1 and lambda2 to explore. We give here an upper limit for lambda1 and lambda2, estimated from the data.
}
\examples{
A <- rbinom(n = 1000, size = 1, prob = 0.5)
X1 <- rbinom(n = 1000, size = 1, prob = 0.5)
X2 <- rnorm(n = 1000, mean = 0, sd = 1)
y <- sample(c(0,1,2), 1000, replace=TRUE, prob=c(0.8, 0.1, 0.1) )
weight <- rep(1, n = 1000)
df <- data.frame(y, A, X1, X2, weight)

max_lambda(stand_formula = y ~ A + X1 + X2,
         exposure = "A",
          df = df,
          weight = weight)
}
\seealso{
\code{\link[nnet]{multinom}}
}
