% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimws_.R
\name{trimws_}
\alias{trimws_}
\title{Remove Leading/Trailing and Duplicated (Symbols that Look Like) White Spaces}
\usage{
trimws_(x)
}
\arguments{
\item{x}{an object with \link[base]{typeof} being \link[base]{character}}
}
\value{
Function \link{trimws_} returns an object of \link[base]{typeof} \link[base]{character}.
}
\description{
To remove leading/trailing and duplicated (symbols that look like) white spaces.

More aggressive than function \link[base]{trimws}.
}
\details{
Function \link{trimws_} is more aggressive than \link[base]{trimws}, that it removes

\itemize{
\item {duplicated white spaces}
\item {symbols that look like white space, such as \verb{\\u00a0} (no-break space)}
}
}
\note{
\link[base]{gsub} keeps \link[base]{attributes}
}
\examples{
(x = c(A = ' a  b  ', b = 'a .  s', ' a  ,  b ; ', '\u00a0  ab '))
base::trimws(x)
# raster::trim(x) # do not want to 'Suggests'
trimws_(x)

(xm = matrix(x, nrow = 2L))
trimws_(xm)

#library(microbenchmark)
#microbenchmark(trimws(x), trimws_(x))

}
