% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdPaikModel.R
\name{ll_AdPaik_eval}
\alias{ll_AdPaik_eval}
\title{Evaluation of Model log-Likelihood}
\usage{
ll_AdPaik_eval(params, dataset, centre, time_axis, dropout_matrix, e_matrix)
}
\arguments{
\item{params}{Parameter vector}

\item{dataset}{Matrix of dimension equal to (number of individuals in the study, number of regressors), where only the regressors
indicated in the formula object are considered.}

\item{centre}{Vector of length equal to the number of individuals in the study, where each element corresponds to the individual
cluster membership.}

\item{time_axis}{Temporal domain}

\item{dropout_matrix}{Binary matrix indicating in which interval of the time domain and individual failed. For an individual,
the sum of the row elements must be equal to 1 (if he/she failed) or 0 (if he/she does not failed).
It has dimension equal to (n_individuals, n_intervals)}

\item{e_matrix}{Matrix of dimension (n_individual, n_intervals), where each element contains the evaluation of the temporal
integral, performed through the function @time_int_eval.}
}
\value{
Overall log-likelihood function value at the provided parameters and data
}
\description{
Evaluation of the log-likelihood function at the provided parameter vector and data.
}
\details{
The function divides the individuals according to their group/cluster membership and then evaluates the group log-likelihood
through another implemented function, but using all and only the individuals belonging to that group.
Then the results are summed together to return the overall log-likelihood value.
}
\keyword{internal}
