% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHiC.R
\name{readHiC}
\alias{readHiC}
\title{Reads Hi-C Contact Data from File}
\usage{
readHiC(
  file,
  chr = NULL,
  binSize = NULL,
  ...,
  debug = getOption("TopDom.debug", FALSE)
)
}
\arguments{
\item{file}{The pathname of a normalize Hi-C contact matrix file
stored as a whitespace-delimited file.  See below for details.
Also a gzip-compressed file can be used.}

\item{chr, binSize}{If the file contains a count matrix without bin
annotation, the latter is created from these parameters.}

\item{debug}{If \code{TRUE}, debug output is produced.}

\item{\ldots}{Arguments passed to \code{\link[utils:read.table]{utils::read.table()}} as-is.}
}
\value{
A list with elements \code{bins} (an N-by-4 data.frame) and
\code{counts} (N-by-N matrix).
}
\description{
Reads Hi-C Contact Data from File
}
\section{Format of HiC contact-matrix file}{

The contact-matrix file should be a whitespace-delimited text file with
neither row names nor column names.  The content should be a N-by-(3+N)
table where the first three columns correspond to \code{chr} (string),
\code{from.coord} (integer position), and \code{to.coord} (integer position).
These column defines the genomic location of the N Hi-C bins (in order).
The last N columns should contain normalized contact counts (float) such
that element (r,3+c) in this table corresponds to count (r,c) in the
normalized contact matrix.

If an N-by-(4+N) table, then the first column is assumed to contain an
\code{id} (integer), and everything else as above.

Example:
\preformatted{
  chr10       0   40000  0 0 0 0 ...
  chr10   40000   80000  0 0 0 0 ...
  chr10   80000  120000  0 0 0 0 ...
  chr10  120000  160000  0 0 0 0 ...
  ...
}
}

\examples{
path <- system.file("exdata", package = "TopDom", mustWork = TRUE)

## Original count data
chr <- "chr19"
pathname <- file.path(path, sprintf("nij.\%s.gz", chr))
data <- readHiC(pathname, chr = chr, binSize = 40e3)
print(data)
str(data)
}
\seealso{
\link{TopDom}.
}
