% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateTheta.R
\name{estimateTheta}
\alias{estimateTheta}
\title{Estimation of the underlying signal.}
\usage{
estimateTheta(
  R.input,
  b,
  num.boot,
  solver,
  type,
  bootstrap.type,
  nCore = ((detectCores() - 1))
)
}
\arguments{
\item{R.input}{A matrix where the rows represent the objects and
the columns the assessors (rankers).}

\item{b}{The penalization term. The suggested value is 0.1.}

\item{num.boot}{The number of boostrap samples created from the input ranked matrix. A positive number is expected.}

\item{solver}{A string that indicates which solver to use. Two options are available, 'gurobi' and 'nloptr'.
We recommend to use gurobi for faster computation. Note, a licence is required. Check the corresponding documentation on how to install gurobi.}

\item{type}{A string that indicates which model to use: four approaches are available: 'restrictedQuadratic', 'fullQuadratic', 'restrictedLinear' and 'fullLinear'.}

\item{bootstrap.type}{A string that indicates which bootstrap method to use: 'classic.bootstrap' or 'poisson.bootstrap'.}

\item{nCore}{The number of cores used for computation. Each core is used to calculate the signals from a bootstrap sample. Default number is detectCores() - 1.}
}
\value{
A list with the estimation information obtained:
 \itemize{
  \item estimation - A data frame with the signal estimation and the standard error computed by the bootstrap for each object
  \item estimatedMatrixNoise - The estimated matrix noise 
  \item time - The execution time of the procedure
  \item allBootstraps - The signal estimates from all bootstrap iterations
}
}
\description{
The main function for the estimation of the signals informing the ranks is called estimateTheta(). The required parameters are: (1) a rank matrix, (2) the number of bootstrap samples (500 is recommended), (3) a constant for the support variables \(b>0\), default is 0.1, (4)  the type of optimization technique: fullLinear, fullQuadratic, restrictedLinear, and restrictedQuadratic (the latter two recommended), (5) the type of  bootstrap sampling scheme: classic.bootstrap and poisson.bootstrap (recommended), and (6) the number of cores for parallel computation. Each bootstrap sample is executed on a dedicated CPU core.
}
\examples{
library(TopKSignal)
set.seed(1421)
p = 8
n = 10
input <- generate.rank.matrix(p, n)
rownames(input$R.input) <- c("a","b","c","d","e","f","g","h")
# For the following code Gurobi needs to be installed
\dontrun{
estimatedSignal <- estimateTheta(R.input = input$R.input, num.boot = 50, b = 0.1, 
solver = "gurobi", type = "restrictedQuadratic", bootstrap.type = "poisson.bootstrap",nCore = 1)   
}
data(estimatedSignal)
estimatedSignal
}
\keyword{estimateTheta}
